#version 450
#include <layout.glsl>

void main() {
    mat4 ipv = camera.ipv;
    float near = camera.near;
    float far = camera.far;
    vec2 position = inputPosition.xy;
    gl_Position = vec4(inputPosition, 1.0);
    outputColor = inputColor;
    outputUv = inputUv;
    outputRayOrigin = (ipv * vec4(position, -1.0, 1.0) * near).xyz;
    float distance = far - near;
    outputRayDirection = (ipv * vec4(position * distance, far + near, distance)).xyz;
}
